# Struts 2 Comprehensive Security Scanner - PowerShell Edition

[English](#english) | [日本語](#japanese)

---

<a name="english"></a>
# English Documentation

## 🚀 Zero-Setup Security Testing for Apache Struts 2 Applications

**Pure PowerShell implementation** - Works instantly on any Windows machine with **no dependencies**!

---

## ⚡ Quick Start

```powershell
# Quick Mode (Recommended) - Comprehensive testing in 2-3 minutes
.\RunStruts2SecurityTest.bat http://localhost:8080/myapp Quick

# Full Mode - Includes OWASP ZAP scan (20-30 minutes)
.\RunStruts2SecurityTest.bat http://localhost:8080/myapp Full
```

**That's it!** No WSL, no Java, no jq, no setup required.

---

## 📦 Dependencies

### Quick Mode (Recommended) ✅
- **ZERO dependencies** - Works instantly on any Windows machine
- No installation required
- No OWASP ZAP needed
- Pure PowerShell only

### Full Mode ⚠️
- **Optional: OWASP ZAP** - Only needed for Phase 9 (ZAP comprehensive scan)
- If ZAP not found: Script will **gracefully skip** ZAP phase and continue
- All 8 core security phases still run without ZAP
- ZAP adds ~30 minutes and 50+ additional vulnerability checks
- **Port Requirement:** ZAP uses port **7777** - this port must be free for Full mode testing

**Bottom line:** Start with Quick mode - no installation needed!

---

## 🎯 Overview

A specialized security testing script designed specifically for **Apache Struts 2** applications. This script extends generic penetration testing capabilities with Struts 2-specific vulnerability detection including OGNL injection, action method exposure, and DevMode detection.

### Key Features

- ✅ **21 OGNL CVE Tests** - Comprehensive testing for S2-001 through S2-062
- ✅ **Action Method Security** - Direct method invocation and namespace traversal (30+ tests)
- ✅ **DevMode Detection** - Identifies development mode exposure
- ✅ **Complete OWASP Coverage** - Security headers, CORS, XSS, SQLi, information disclosure
- ✅ **ZAP Integration** - Optional deep penetration testing with OWASP ZAP (Full mode)
- ✅ **Windows Native** - No WSL or Linux dependencies
- ✅ **Fast Execution** - 2-3 minutes for comprehensive Struts 2 testing

---

## 📋 Complete Test Coverage

### Quick Mode: **8 Test Phases** (2-3 minutes)

**Total: 80+ individual security checks**

### Full Mode: Quick + **ZAP Phase** (20-30 minutes)

**Total: 130+ individual security checks**

---

## 📊 Detailed Scan Coverage

### 🔵 Quick Mode (80+ Checks) - What You Get:

#### Phase 1: Security Headers Analysis
- ✅ **6 tests** - HSTS, X-Frame-Options, X-Content-Type-Options, X-XSS-Protection, CSP, Referrer-Policy

#### Phase 2: CORS Security Tests
- ✅ **2 tests** - Wildcard origin detection, Evil origin rejection

#### Phase 3: XSS Vulnerability Tests
- ✅ **24 tests** (4 payloads × 6 parameters)
  - Payloads: `<script>alert('XSS')</script>`, `javascript:alert('XSS')`, `'"><script>`, `<img onerror>`
  - Parameters: q, search, query, name, message, text

#### Phase 4: SQL Injection Tests
- ✅ **20 tests** (4 payloads × 5 parameters)
  - Payloads: `' OR '1'='1`, `'; DROP TABLE`, `UNION SELECT`, `admin'--`
  - Parameters: id, user, username, email, search

#### Phase 5: Information Disclosure
- ✅ **4 tests** - `/.git`, `/.env`, `/admin`, `/phpmyadmin`

#### Phase 6: Struts 2 DevMode Detection
- ✅ **3 tests** - `debug=xml`, `debug=console`, `struts.devMode=true`

#### Phase 7: OGNL Injection Testing ⚠️ CRITICAL
- ✅ **21 CVE tests** covering S2-001 through S2-062:
  - **S2-001** (CVE-2007-4556) - Parameter injection
  - **S2-003** (CVE-2008-6504) - XWork ParameterInterceptor bypass
  - **S2-005** (CVE-2010-1870) - OGNL evaluation in parameter names
  - **S2-007** (CVE-2012-0391) - Conversion error OGNL evaluation
  - **S2-008** (CVE-2012-0392) - Cookie interceptor OGNL injection
  - **S2-009** (CVE-2011-3923) - ParameterInterceptor vulnerability
  - **S2-012** (CVE-2013-1965) - Redirect action OGNL injection
  - **S2-013** (CVE-2013-1966) - URL parameter OGNL injection
  - **S2-015** (CVE-2013-2134) - Wildcard matching OGNL evaluation
  - **S2-016** (CVE-2013-2135) - DefaultActionMapper prefix injection
  - **S2-029** (CVE-2016-0785) - Tag attribute OGNL evaluation
  - **S2-032** (CVE-2016-3081) - Dynamic Method Invocation RCE
  - **S2-033** (CVE-2016-3687) - REST plugin XStream RCE
  - **S2-037** (CVE-2016-4438) - REST plugin configuration bypass
  - **S2-045** (CVE-2017-5638) - Jakarta Multipart parser RCE
  - **S2-046** (CVE-2017-9791) - Content-Type header OGNL injection
  - **S2-053** (CVE-2017-12611) - Freemarker template injection
  - **S2-057** (CVE-2018-11776) - Namespace configuration RCE
  - **S2-059** (CVE-2019-0230) - Tag attribute skillful match OGNL
  - **S2-061** (CVE-2020-17530) - Forced OGNL evaluation
  - **S2-062** (CVE-2021-31805) - ParameterInterceptor bypass
- Tests 5 endpoints: Base URL, /index.action, /login.action, /user.action, /admin.action

#### Phase 8: Action Method Exposure Testing ⚠️ CRITICAL
- ✅ **30+ Direct Method Invocation (DMI) tests** (6 methods × 5 actions)
  - Methods: execute, input, delete, update, admin, list
  - Actions: login, user, admin, action, default
  - Pattern: `login!execute.action`, `admin!delete.action`, etc.
- ✅ **5 Namespace Traversal tests**
  - Namespaces: /admin, /api, /secure, /internal, /management

---

### 🟢 Full Mode (130+ Checks) - Additional Coverage:

#### Phase 9: OWASP ZAP Comprehensive Scan
- ✅ **Advanced XSS Detection** - DOM-based, stored, reflected variants
- ✅ **Advanced SQL Injection** - Blind SQLi, time-based SQLi, boolean-based
- ✅ **Command Injection** - OS command execution tests
- ✅ **Path Traversal** - Directory traversal vulnerabilities
- ✅ **XXE (XML External Entity)** - XML parser vulnerabilities
- ✅ **CSRF Detection** - Cross-Site Request Forgery tests
- ✅ **Session Management** - Session fixation, weak tokens
- ✅ **Cookie Security** - HttpOnly, Secure, SameSite attributes
- ✅ **User Agent Fuzzing** - Browser/client spoofing tests
- ✅ **Authentication Bypass** - Login mechanism weaknesses
- ✅ **Authorization Issues** - Privilege escalation tests
- ✅ **Input Validation** - Format string, buffer overflow
- ✅ **SSL/TLS Configuration** - Certificate validation, weak ciphers
- ✅ **Information Leakage** - Error messages, stack traces
- ✅ **HTML Report Generation** - Detailed findings with remediation

**Total ZAP checks:** 50+ additional vulnerability rules

---

## 📊 Detailed Test Phases

### Phase 1: Security Headers Analysis (6 tests)

**Purpose:** Verify HTTP security headers that protect against common web attacks.

**Tests:**
1. **HSTS (HTTP Strict Transport Security)** - HTTPS only
   - Forces browsers to use HTTPS
   - Risk if missing: LOW - Man-in-the-middle attacks possible
   
2. **X-Frame-Options**
   - Prevents clickjacking attacks
   - Risk if missing: LOW - UI redress attacks possible
   
3. **X-Content-Type-Options**
   - Prevents MIME-sniffing attacks
   - Risk if missing: LOW - Content type confusion attacks
   
4. **X-XSS-Protection**
   - Enables browser XSS filter
   - Risk if missing: LOW - Increases XSS attack surface
   
5. **Content-Security-Policy (CSP)**
   - Prevents injection attacks
   - Risk if missing: MEDIUM - Content injection vulnerabilities
   
6. **Referrer-Policy**
   - Controls referrer information leakage
   - Risk if missing: LOW - Information disclosure

**Risk Assessment:** Missing headers = LOW to MEDIUM risk

---

### Phase 2: CORS Security Tests (2 tests)

**Purpose:** Verify Cross-Origin Resource Sharing configuration security.

**Tests:**
1. **Wildcard Origin Detection**
   - Checks for `Access-Control-Allow-Origin: *`
   - Payload: `Origin: https://evil-site.com`
   - Risk if found: HIGH - Any website can access your API
   
2. **Evil Origin Rejection**
   - Tests if malicious origins are accepted
   - Payload: `Origin: https://evil-site.com`
   - Risk if accepted: HIGH - Unauthorized cross-origin access

**Risk Assessment:** Misconfigured CORS = HIGH risk

---

### Phase 3: XSS Vulnerability Tests (24 tests)

**Purpose:** Detect Cross-Site Scripting vulnerabilities.

**Payloads Tested (4):**
1. `<script>alert('XSS')</script>` - Basic script injection
2. `javascript:alert('XSS')` - JavaScript protocol
3. `'"><script>alert('XSS')</script>` - Context breaking
4. `<img src=x onerror=alert('XSS')>` - Event handler injection

**Parameters Tested (6):**
- q, search, query, name, message, text

**Total Tests:** 4 payloads × 6 parameters = 24 tests

**Detection Method:** Checks if payload appears unescaped in response

**Risk Assessment:** XSS found = HIGH risk - Code execution in user browsers

---

### Phase 4: SQL Injection Tests (20 tests)

**Purpose:** Detect SQL injection vulnerabilities.

**Payloads Tested (4):**
1. `' OR '1'='1` - Authentication bypass
2. `'; DROP TABLE users; --` - Statement termination
3. `' UNION SELECT null, null --` - Union-based extraction
4. `admin'--` - Comment injection

**Parameters Tested (5):**
- id, user, username, email, search

**Total Tests:** 4 payloads × 5 parameters = 20 tests

**Detection Method:** Looks for SQL error patterns in response:
- `sql syntax`, `mysql error`, `postgresql error`, `ora-[0-9]+`

**Risk Assessment:** SQLi found = HIGH risk - Database compromise possible

---

### Phase 5: Information Disclosure (4 tests)

**Purpose:** Detect exposed sensitive files and paths.

**Paths Tested:**
1. `/.git` - Source code repository
   - Risk if accessible: HIGH - Complete source code exposure
   
2. `/.env` - Environment configuration
   - Risk if accessible: HIGH - Database credentials, API keys exposed
   
3. `/admin` - Administrative interface
   - Risk if accessible: MEDIUM - Unauthorized admin access possible
   
4. `/phpmyadmin` - Database management interface
   - Risk if accessible: MEDIUM - Database exposure

**Detection Method:** HTTP 200 response = accessible

**Risk Assessment:** 
- .git/.env accessible = HIGH risk
- Admin paths accessible = MEDIUM risk

---

### Phase 6: Struts 2 DevMode Detection (3 tests)

**Purpose:** Identify if Struts 2 development mode is enabled in production.

**Test Parameters:**
1. `debug=xml` - XML debug output
2. `debug=console` - Console debug output
3. `struts.devMode=true` - Direct devMode parameter

**Detection Patterns:**
- `devmode`
- `debug mode`
- `struts debug`
- `action mapping`

**Why This Matters:**
DevMode exposes internal application structure, action mappings, and debug information that attackers can use to understand and exploit the application.

**Risk Assessment:** DevMode enabled = HIGH risk

---

### Phase 7: Comprehensive OGNL Injection Testing ⚠️ CRITICAL

**Purpose:** Test for Remote Code Execution (RCE) vulnerabilities via OGNL expression language.

**THIS IS THE MOST CRITICAL PHASE FOR STRUTS 2 APPLICATIONS**

Tests **21 CVEs** (S2-001 through S2-062):

#### Test 1: Content-Type OGNL Injection (S2-045, S2-046)

**CVE:** CVE-2017-5638 (S2-045), CVE-2017-9791 (S2-046)

**Attack Vector:** HTTP Content-Type header

**Payload:**
```
Content-Type: %{(#_='multipart/form-data').(#dm=@ognl.OgnlContext@DEFAULT_MEMBER_ACCESS)}
```

**How It Works:**
- Exploits OGNL evaluation in multipart parser
- Allows arbitrary code execution via Content-Type header
- Can execute system commands remotely

**Risk:** CRITICAL - Complete server compromise

---

#### Test 2: Redirect Parameter OGNL Injection (S2-057)

**CVE:** CVE-2018-11776 (S2-057)

**Attack Vector:** URL redirect parameter

**Payload:**
```
redirect:%{@java.lang.System@getProperty('user.name')}
```

**How It Works:**
- Exploits namespace configuration issues
- OGNL expressions in redirect parameters get evaluated
- Can execute arbitrary Java code

**Risk:** CRITICAL - Remote Code Execution

---

#### Test 3: URL Parameter OGNL Injection

**Attack Vector:** URL query parameters

**Payloads Tested (3):**
1. `%{#context['xwork.MethodAccessor.denyMethodExecution']=false}`
2. `%{@java.lang.System@getProperty('user.name')}`
3. `${@java.lang.System@getProperty('os.name')}`

**How It Works:**
- Tests if URL parameters evaluate OGNL expressions
- Attempts to access Java system properties
- Can escalate to command execution

**Risk:** HIGH to CRITICAL

---

#### Test 4: Deep OGNL Scan (18 additional CVEs)

**Comprehensive CVE Coverage:**

**S2-001, S2-003, S2-005 (Parameter Injection)**
```
Payload: %{#a=(new java.lang.ProcessBuilder(new java.lang.String[]{'whoami'})).start()}
Tests: Parameter-based OGNL evaluation
Risk: Command execution via request parameters
```

**S2-007, S2-008, S2-009 (Conversion Errors)**
```
Payload: age=1&name=%{#context['xwork.MethodAccessor.denyMethodExecution']=false}
Tests: Type conversion vulnerabilities
Risk: RCE via conversion error handling
```

**S2-012, S2-013 (Action Redirect)**
```
Payload: redirect:%{#a=(new java.lang.ProcessBuilder(new java.lang.String[]{'id'})).start()}
Tests: Redirect-based injection
Risk: RCE via redirect parameters
```

**S2-015, S2-016 (Wildcard Matching)**
```
Payload: *{#context['xwork.MethodAccessor.denyMethodExecution']=false}
Tests: Wildcard pattern vulnerabilities
Risk: RCE via action wildcards
```

**S2-029 (Tag Attributes)**
```
Payload: %{(#_='multipart/form-data').(#_memberAccess=@ognl.OgnlContext@DEFAULT_MEMBER_ACCESS)}
Tests: Tag attribute injection
Risk: RCE via JSP tags
```

**S2-032, S2-033 (Dynamic Method Invocation - DMI)**
```
Payload: method:%{#_memberAccess=@ognl.OgnlContext@DEFAULT_MEMBER_ACCESS}
Tests: DMI-based exploitation
Risk: RCE via method: prefix
```

**S2-037 (REST Plugin)**
```
Payload: class.classLoader.resources.dirContext.docBase=.
Tests: REST plugin vulnerabilities
Risk: RCE via REST endpoints
```

**S2-053 (Freemarker)**
```
Payload: %{(#dm=@ognl.OgnlContext@DEFAULT_MEMBER_ACCESS)}
Tests: Freemarker template injection
Risk: RCE via template evaluation
```

**S2-059 (Skillful Match)**
```
Payload: %{(#context['xwork.MethodAccessor.denyMethodExecution']=false)}
Tests: Tag attribute skillful matching
Risk: RCE via tag attributes
```

**S2-062 (ParameterInterceptor)**
```
Payload: class['classLoader']['resources']['dirContext']['docBase']
Tests: Parameter interceptor bypass
Risk: RCE via parameter pollution
```

**Testing Endpoints:**
- Base URL
- /index.action
- /login.action
- /user.action
- /admin.action

**Detection Method:**
- Looks for OGNL exception patterns
- Checks for expression evaluation indicators
- Detects ProcessBuilder, memberAccess keywords

**Risk Assessment:** Any OGNL vulnerability = CRITICAL - Complete server compromise

---

### Phase 8: Action Method Exposure Testing ⚠️ CRITICAL

**Purpose:** Detect Direct Method Invocation (DMI) vulnerabilities and namespace traversal issues.

#### Test 1: Direct Method Invocation (30 combinations)

**What Is DMI?**
Struts 2 allows calling action methods directly using the `!` syntax:
- `login!execute.action` - Calls execute() method
- `admin!delete.action` - Calls delete() method

**Why This Matters:**
If DMI is enabled, attackers can bypass security checks by calling internal methods directly.

**Methods Tested (6):**
1. `execute` - Main action execution
2. `input` - Input form rendering
3. `delete` - Delete operations
4. `update` - Update operations
5. `admin` - Administrative functions
6. `list` - List/enumeration operations

**Base Actions Tested (5):**
1. `login` - Authentication actions
2. `user` - User management actions
3. `admin` - Administrative actions
4. `action` - Generic actions
5. `default` - Default actions

**Test Pattern:** `{base}!{method}.action`

**Examples:**
- `login!execute.action` - HTTP 200 = exposed
- `admin!delete.action` - HTTP 200 = exposed
- `user!update.action` - HTTP 200 = exposed

**Total Tests:** 6 methods × 5 actions = 30 tests

**Detection Method:**
- HTTP 200 or 302 response = method is exposed
- HTTP 404 = method not accessible (good)

**Risk Assessment:** Exposed methods = HIGH risk - Bypass security controls

---

#### Test 2: Namespace Traversal Testing (5 patterns)

**Purpose:** Test if namespace traversal attacks are possible.

**Namespaces Tested:**
1. `/admin` - Administrative namespace
2. `/api` - API namespace
3. `/secure` - Secured namespace
4. `/internal` - Internal operations namespace
5. `/management` - Management namespace

**Test Pattern:** `{TargetUrl}{namespace}/..`

**How It Works:**
- Tests if `../` traversal bypasses namespace restrictions
- Checks if traversal exposes unauthorized namespaces

**Detection Method:**
- HTTP 200 + content match = traversal possible
- Content patterns: `admin`, `secure`, `internal`

**Risk Assessment:** Traversal possible = MEDIUM risk

---

### Phase 9: OWASP ZAP Comprehensive Scan (Full Mode Only)

**Purpose:** Deep penetration testing using OWASP ZAP's 50+ vulnerability rules.

**Requirements:** OWASP ZAP installed (https://www.zaproxy.org/download/)

**Tests Include:**
- ✅ Advanced XSS detection
- ✅ Advanced SQL injection (blind, time-based)
- ✅ Command injection
- ✅ Path traversal
- ✅ XXE (XML External Entity)
- ✅ CSRF vulnerabilities
- ✅ Session management issues
- ✅ Cookie security (SameSite, HttpOnly, Secure)
- ✅ User agent fuzzing
- ✅ And 40+ more security checks
**Output:** Live console output showing scan progress and findings

---

## 📈 Risk Scoring System

### How the Score Works

The scanner uses a **percentage-based scoring system (0-100)**, where:
- **0 = Perfect Security** (no vulnerabilities)
- **100 = Maximum Risk** (all critical tests failed)
- Each test has a **weight percentage** based on its security impact
- Failing a test **adds its weight** to your score

### Test Weight Distribution

All tests are weighted to total 100%. Here's the breakdown:

#### 🔴 Critical Struts 2 Tests (60% total)

| Test | Weight | Why It Matters |
|------|--------|----------------|
| **OGNL Injection (S2-045/046)** | 15% | RCE via Content-Type header |
| **OGNL Deep Scan (S2-001 to S2-062)** | 15% | 21 CVEs, complete RCE coverage |
| **OGNL URL Parameters** | 10% | RCE via query parameters |
| **DevMode Detection** | 10% | Debug mode in production = RCE |
| **Action Method Exposure (DMI)** | 10% | Direct method invocation bypass (2% each × 5) |

#### 🟡 Important Security Tests (25% total)

| Test | Weight | Why It Matters |
|------|--------|----------------|
| **Content-Security-Policy** | 5% | Prevents injection attacks |
| **CORS Security** | 5% | Protects API from unauthorized access |
| **XSS Protection** | 5% | Prevents cross-site scripting |
| **SQL Injection Protection** | 5% | Prevents database attacks |
| **Namespace Traversal** | 5% | Prevents unauthorized namespace access (1% each × 5) |

#### 🟢 Standard Security Headers (15% total)

| Test | Weight | Why It Matters |
|------|--------|----------------|
| **X-Frame-Options** | 3% | Clickjacking protection |
| **X-Content-Type-Options** | 3% | MIME-sniffing protection |
| **X-XSS-Protection** | 3% | Browser XSS filter |
| **Referrer-Policy** | 3% | Information leakage control |
| **Information Disclosure** | 3% | Sensitive path exposure |

### Example Scenarios

#### Scenario 1: Well-Secured App
```
Failed Tests:
- Missing X-Frame-Options: +3%
- Missing Referrer-Policy: +3%

Final Score: 6/100 = LOW Risk ✅
```

#### Scenario 2: Typical Vulnerable App
```
Failed Tests:
- OGNL S2-045/046: +15%
- OGNL Deep Scan: +15%
- DevMode Enabled: +10%
- 5 Exposed Methods: +10%
- Missing CSP: +5%
- 4 Missing Headers: +12%

Final Score: 67/100 = HIGH Risk ⚠️
```

#### Scenario 3: Critical Risk App
```
Failed Tests:
- OGNL S2-045/046: +15%
- OGNL URL Parameters: +10%
- OGNL Deep Scan: +15%
- DevMode Enabled: +10%
- 5 Exposed Methods: +10%
- CORS Wildcard: +5%
- XSS Vulnerable: +5%
- SQLi Vulnerable: +5%
- Missing CSP: +5%
- All Headers Missing: +15%

Final Score: 95/100 = CRITICAL Risk 🛑
```

### Risk Level Thresholds

| Score Range | Risk Level | Action Required |
|-------------|------------|------------------|
| **0-20** | 🟢 LOW | Minor issues, good security posture |
| **21-40** | 🟡 MEDIUM | Some vulnerabilities, plan fixes |
| **41-60** | 🟠 HIGH | Serious issues, urgent attention needed |
| **61-100** | 🔴 CRITICAL | Severe vulnerabilities, immediate patching required |

### Why This System Works Better

✅ **Accurate Weighting** - OGNL RCE (15%) weighs more than missing header (3%)
✅ **No Caps** - Can't game the system by having many small issues
✅ **Simple Math** - Just add up the weights of failed tests
✅ **Scales Correctly** - 12 HIGH risks = higher score than current system
✅ **Always Fair** - Score directly reflects actual vulnerabilities

---
**Scan Types:**
1. **Spider Scan** - Discovers all application URLs
2. **Passive Scan** - Analyzes responses (no attacks)
3. **Active Scan** - Actively tests vulnerabilities

**Risk Levels Detected:** HIGH, MEDIUM, LOW, INFORMATIONAL

---

## 📊 Understanding Results

### Risk Score Calculation

```
Risk Score = (HIGH × 10) + (MEDIUM × 3) + (LOW × 1)
Maximum Score = 100 (capped)
```

### Risk Levels Explained

**HIGH RISK (10 points each)** - Immediate action required
- **Examples:** OGNL injection, exposed action methods, DevMode enabled
- **Impact:** Remote Code Execution, complete server compromise
- **Action:** Fix immediately, upgrade Struts 2, disable DMI

**MEDIUM RISK (3 points each)** - Fix soon
- **Examples:** Missing CSP header, accessible admin paths, namespace traversal
- **Impact:** Increased attack surface
- **Action:** Add security headers, restrict access, fix configuration

**LOW RISK (1 point each)** - Recommended fixes
- **Examples:** Missing security headers (X-Frame-Options, etc.)
- **Impact:** Minor security improvements
- **Action:** Add headers following security best practices

### Risk Score Interpretation

- **0-20:** LOW risk - Good security posture
- **21-40:** MEDIUM risk - Some improvements needed
- **41-60:** HIGH risk - Multiple issues found
- **61+:** CRITICAL - Immediate remediation required

---

## 💡 Usage Examples

### Example 1: Test Localhost Application
```powershell
.\RunStruts2SecurityTest.bat http://localhost:8080/myapp Quick
```

### Example 2: Test Remote Staging Environment
```powershell
.\RunStruts2SecurityTest.bat https://staging.example.com/myapp Quick
```

### Example 3: Full Scan with ZAP
```powershell
# Install ZAP first: https://www.zaproxy.org/download/
.\RunStruts2SecurityTest.bat http://localhost:8080/myapp Full
```

### Example 4: Docker Application
```powershell
# Docker apps use host.docker.internal instead of localhost
.\RunStruts2SecurityTest.bat http://host.docker.internal:7070/myapp Quick
```

### Example 5: Custom ZAP Installation Path
```powershell
powershell -ExecutionPolicy Bypass -File .\Struts2-SecurityTest.ps1 `
  -TargetUrl "http://localhost:8080/myapp" `
  -Mode Full `
  -ZapPath "D:\Tools\ZAP\zap.bat"
```

---

## 🔧 Troubleshooting

### Cannot connect to target
```
✗ Cannot connect to target URL
Error: The remote server returned an error: (404) Not Found
```

**Solutions:**
1. Verify application is running: Test URL in browser first
2. Check URL spelling and port number
3. For Docker apps: Use `host.docker.internal` instead of `localhost`
4. Check firewall settings

### ZAP not found (Full mode only)
```
! ZAP not found at: C:\Program Files\ZAP\Zed Attack Proxy\zap.bat
! Skipping ZAP scan
```

**Solutions:**
1. Install OWASP ZAP from https://www.zaproxy.org/download/
2. Specify custom path with `-ZapPath` parameter
3. Or use Quick mode (ZAP not required)

### ZAP port conflict (Full mode only)
```
Failed to start the main proxy: java.net.BindException Address already in use: bind
```

**Problem:** ZAP uses port **7777** which is already in use by another application.

**Solutions:**
1. Stop any application using port 7777
2. Check with: `netstat -ano | findstr :7777`
3. Or use Quick mode (no ZAP, no port requirement)

---

## 🎯 When to Use Each Mode

### Quick Mode (2-3 minutes) - Recommended

**Use When:**
- ✅ Fast Struts 2 vulnerability assessment needed
- ✅ CI/CD pipeline integration
- ✅ Pre-deployment security checks
- ✅ Regular security assessments
- ✅ OWASP ZAP not available

**What You Get:**
- All 8 security test phases
- 21 OGNL CVE tests
- 30 action method tests
- Complete Struts 2 coverage

### Full Mode (20-30 minutes)

**Use When:**
- ✅ Comprehensive security audit required
- ✅ Pre-production testing
- ✅ Penetration testing engagement
- ✅ Compliance requirements (PCI-DSS, etc.)
- ✅ Detailed vulnerability reports needed

**What You Get:**
- Everything in Quick mode
- OWASP ZAP deep scan (50+ checks)
- Detailed HTML reports
- Advanced vulnerability detection

---

## ✨ Key Advantages

### 1. Zero Setup
- ✅ No WSL installation
- ✅ No Java required
- ✅ No jq parser
- ✅ Works instantly on any Windows machine

### 2. Windows Native
- ✅ Direct localhost access
- ✅ No IP translation issues
- ✅ No line-ending problems (CRLF/LF)
- ✅ Perfect for Windows development

### 3. Comprehensive Struts 2 Testing
- ✅ 21 OGNL CVEs (S2-001 through S2-062)
- ✅ 30 action method exposure tests
- ✅ 5 namespace traversal tests
- ✅ DevMode detection

### 4. Fast Execution
- ✅ Quick: 2-3 minutes
- ✅ Full: 20-30 minutes
- ✅ No startup delays

### 5. Production-Ready
- ✅ Detects real vulnerabilities
- ✅ Clear, actionable output
- ✅ Risk scoring
- ✅ Detailed remediation guidance

---

## 📁 Files

- **Struts2-SecurityTest.ps1** - Main security scanner
- **RunStruts2SecurityTest.bat** - Convenient launcher
- **README.md** - This documentation
- **zap-reports/** - ZAP scan reports (Full mode)

---

## 🛡️ Security Warning

**⚠️ AUTHORIZED TESTING ONLY**

These tests are read-only but may generate error logs. Only use on:
- ✅ Your own applications
- ✅ Development/staging environments
- ✅ Systems you have permission to test

**DO NOT** run against:
- ❌ Production systems without authorization
- ❌ Third-party applications
- ❌ Systems you don't own

---

## 📚 Resources

- **OWASP ZAP:** https://www.zaproxy.org/
- **Struts Security:** https://struts.apache.org/security/
- **CVE Database:** https://cve.mitre.org/
- **OWASP Top 10:** https://owasp.org/www-project-top-ten/

---

<a name="japanese"></a>
# 日本語ドキュメント

## 🚀 Apache Struts 2アプリケーション用のゼロセットアップセキュリティテスト

**Pure PowerShell実装** - 依存関係なしでWindows上で即座に動作！

---

## ⚡ クイックスタート

```powershell
# クイックモード（推奨） - 2-3分で包括的テスト
.\RunStruts2SecurityTest.bat http://localhost:8080/myapp Quick

# フルモード - OWASP ZAPスキャン込み（20-30分）
.\RunStruts2SecurityTest.bat http://localhost:8080/myapp Full
```

**これだけです！** WSL、Java、jq、セットアップ不要。

---

## 📦 依存関係

### クイックモード（推奨） ✅
- **依存関係ゼロ** - あらゆるWindowsマシンで即座に動作
- インストール不要
- OWASP ZAP不要
- Pure PowerShellのみ

### フルモード ⚠️
- **オプション: OWASP ZAP** - フェーズ9(ZAP包括スキャン)のみ必要
- ZAPが見つからない場合:スクリプトは**ZAPフェーズをスキップ**して続行
- 8つのコアセキュリティフェーズはZAPなしでも実行
- ZAPは約30分と50+の追加脆弱性チェックを追加
- **ポート要件:** ZAPはポート**7777**を使用 - フルモードテスト時にこのポートは空いている必要があります

**結論:** クイックモードから始めましょう - インストール不要！

---

## 🎯 概要

**Apache Struts 2**アプリケーション専用のセキュリティテストスクリプト。OGNL インジェクション、アクションメソッド露出、DevMode検出など、Struts 2特有の脆弱性検出機能を備えています。

### 主な機能

- ✅ **21個のOGNL CVEテスト** - S2-001からS2-062までの包括的テスト
- ✅ **アクションメソッドセキュリティ** - 直接メソッド呼び出しと名前空間トラバーサル（30+テスト）
- ✅ **DevMode検出** - 開発モードの露出を特定
- ✅ **完全なOWASP対応** - セキュリティヘッダー、CORS、XSS、SQLi、情報漏洩
- ✅ **ZAP統合** - OWASP ZAPによる深層ペネトレーションテスト（フルモード）
- ✅ **Windows ネイティブ** - WSLやLinux依存関係なし
- ✅ **高速実行** - Struts 2包括テストが2-3分

---

## 📋 完全なテストカバレッジ

### クイックモード: **8テストフェーズ** (2-3分)

**合計: 80+個のセキュリティチェック**

### フルモード: クイック + **ZAPフェーズ** (20-30分)

**合計: 130+個のセキュリティチェック**

---

## 📊 詳細なスキャンカバレッジ

### 🔵 クイックモード (80+チェック) - 実行内容:

#### フェーズ1: セキュリティヘッダー解析
- ✅ **6テスト** - HSTS, X-Frame-Options, X-Content-Type-Options, X-XSS-Protection, CSP, Referrer-Policy

#### フェーズ2: CORSセキュリティテスト
- ✅ **2テスト** - ワイルドカードオリジン検出、悪意のあるオリジン拒否

#### フェーズ3: XSS脆弱性テスト
- ✅ **24テスト** (4ペイロード × 6パラメータ)
  - ペイロード: `<script>alert('XSS')</script>`, `javascript:alert('XSS')`, `'"><script>`, `<img onerror>`
  - パラメータ: q, search, query, name, message, text

#### フェーズ4: SQLインジェクションテスト
- ✅ **20テスト** (4ペイロード × 5パラメータ)
  - ペイロード: `' OR '1'='1`, `'; DROP TABLE`, `UNION SELECT`, `admin'--`
  - パラメータ: id, user, username, email, search

#### フェーズ5: 情報漏洩テスト
- ✅ **4テスト** - `/.git`, `/.env`, `/admin`, `/phpmyadmin`

#### フェーズ6: Struts 2 DevMode検出
- ✅ **3テスト** - `debug=xml`, `debug=console`, `struts.devMode=true`

#### フェーズ7: OGNLインジェクションテスト ⚠️ 重大
- ✅ **21個のCVEテスト** S2-001からS2-062まで:
  - **S2-001** (CVE-2007-4556) - パラメータインジェクション
  - **S2-003** (CVE-2008-6504) - XWork ParameterInterceptorバイパス
  - **S2-005** (CVE-2010-1870) - パラメータ名でのOGNL評価
  - **S2-007** (CVE-2012-0391) - 変換エラーOGNL評価
  - **S2-008** (CVE-2012-0392) - Cookie interceptor OGNLインジェクション
  - **S2-009** (CVE-2011-3923) - ParameterInterceptor脆弱性
  - **S2-012** (CVE-2013-1965) - リダイレクトアクションOGNLインジェクション
  - **S2-013** (CVE-2013-1966) - URLパラメータOGNLインジェクション
  - **S2-015** (CVE-2013-2134) - ワイルドカードマッチングOGNL評価
  - **S2-016** (CVE-2013-2135) - DefaultActionMapperプレフィックスインジェクション
  - **S2-029** (CVE-2016-0785) - タグ属性OGNL評価
  - **S2-032** (CVE-2016-3081) - 動的メソッド呼び出しRCE
  - **S2-033** (CVE-2016-3687) - RESTプラグインXStream RCE
  - **S2-037** (CVE-2016-4438) - RESTプラグイン設定バイパス
  - **S2-045** (CVE-2017-5638) - Jakarta MultipartパーサーRCE
  - **S2-046** (CVE-2017-9791) - Content-TypeヘッダーOGNLインジェクション
  - **S2-053** (CVE-2017-12611) - Freemarkerテンプレートインジェクション
  - **S2-057** (CVE-2018-11776) - 名前空間設定RCE
  - **S2-059** (CVE-2019-0230) - タグ属性スキルフルマッチOGNL
  - **S2-061** (CVE-2020-17530) - 強制OGNL評価
  - **S2-062** (CVE-2021-31805) - ParameterInterceptorバイパス
- 5つのエンドポイントをテスト: ベースURL, /index.action, /login.action, /user.action, /admin.action

#### フェーズ8: アクションメソッド露出テスト ⚠️ 重大
- ✅ **30+直接メソッド呼び出し(DMI)テスト** (6メソッド × 5アクション)
  - メソッド: execute, input, delete, update, admin, list
  - アクション: login, user, admin, action, default
  - パターン: `login!execute.action`, `admin!delete.action`, など
- ✅ **5名前空間トラバーサルテスト**
  - 名前空間: /admin, /api, /secure, /internal, /management

---

### 🟢 フルモード (130+チェック) - 追加カバレッジ:

#### フェーズ9: OWASP ZAP包括スキャン
- ✅ **高度なXSS検出** - DOMベース、保存型、反射型バリアント
- ✅ **高度なSQLインジェクション** - ブラインドSQLi、タイムベースSQLi、ブールベース
- ✅ **コマンドインジェクション** - OSコマンド実行テスト
- ✅ **パストラバーサル** - ディレクトリトラバーサル脆弱性
- ✅ **XXE (XML External Entity)** - XMLパーサー脆弱性
- ✅ **CSRF検出** - クロスサイトリクエストフォージェリテスト
- ✅ **セッション管理** - セッション固定、弱いトークン
- ✅ **クッキーセキュリティ** - HttpOnly, Secure, SameSite属性
- ✅ **ユーザーエージェントファジング** - ブラウザ/クライアントスプーフィングテスト
- ✅ **認証バイパス** - ログインメカニズムの弱点
- ✅ **認可問題** - 権限昇格テスト
- ✅ **入力検証** - フォーマット文字列、バッファオーバーフロー
- ✅ **SSL/TLS設定** - 証明書検証、弱い暗号
- ✅ **情報漏洩** - エラーメッセージ、スタックトレース
- ✅ **HTMLレポート生成** - 修復方法付き詳細な発見事項

**ZAPチェック合計:** 50+追加の脆弱性ルール

---

## 📈 リスクスコアリングシステム

### スコアの仕組み

スキャナーは**0-100のリスクスコア**を計算します：
- **0 = 完璧なセキュリティ** (脆弱性が見つからない)
- **100 = 壊滅的** (重大な脆弱性が存在)

### スコア計算式

```
ステップ1: 検出結果から基本スコアを計算
- HIGH リスク: 各15ポイント（最大70ポイント）
- MEDIUM リスク: 各2ポイント（最大20ポイント）
- LOW リスク: 各1ポイント（最大10ポイント）

ステップ2: 合格率による減算を適用
- 合格率 = (合格テスト数 / 総テスト数)
- 減算 = 全テスト合格で最大25%オフ
- 最終スコア = 基本スコア × (1.0 - 合格率 × 0.25)
```

### 計算例

**テスト結果:**
- 合格テスト: 25のうち6 (合格率24%)
- HIGH リスク検出: 9 → 70ポイント（上限70）
- MEDIUM リスク検出: 8 → 16ポイント
- LOW リスク検出: 4 → 4ポイント

**計算:**
```
基本スコア = 70 + 16 + 4 = 90ポイント
合格率 = 6/25 = 24% = 0.24
減算係数 = 1.0 - (0.24 × 0.25) = 0.94
最終スコア = 90 × 0.94 = 84/100
```

**結果: 84/100 = HIGH リスク**

これは理にかなっています：
- ✅ 重要なテストに合格（CORS、XSS、SQLi保護）
- ❌ しかしOGNLインジェクションテストに失敗（CRITICAL）
- ❌ DevMode有効（HIGH リスク）
- ❌ 複数のアクションメソッド露出

### リスクレベル閾値

| スコア範囲 | リスクレベル | 説明 |
|------------|--------------|------|
| **0-20** | LOW | 軽微な問題、十分にセキュアなアプリケーション |
| **21-50** | MEDIUM | いくつかの脆弱性、注意が必要 |
| **51-80** | HIGH | 深刻な脆弱性、緊急の修正が必要 |
| **81-100** | CRITICAL | 重大な脆弱性、即座の対応が必要 |

### スコアの理解

- **合格テストでスコア減少:** セキュリティテストに合格するとスコアが下がります
- **HIGH リスク検出が支配的:** 単一のOGNL RCE脆弱性でHIGHカテゴリが最大値に
- **完璧なスコアは 0/100:** 脆弱性ゼロ = リスクポイントゼロ

---

## 📊 詳細なテストフェーズ

### フェーズ1: セキュリティヘッダー解析 (6テスト)

**目的:** 一般的なWeb攻撃から保護するHTTPセキュリティヘッダーの確認。

**テスト内容:**
1. **HSTS (HTTP Strict Transport Security)** - HTTPSのみ
   - ブラウザにHTTPSの使用を強制
   - 欠落時のリスク: 低 - 中間者攻撃が可能
   
2. **X-Frame-Options**
   - クリックジャッキング攻撃を防止
   - 欠落時のリスク: 低 - UIリドレス攻撃が可能
   
3. **X-Content-Type-Options**
   - MIMEスニッフィング攻撃を防止
   - 欠落時のリスク: 低 - コンテンツタイプ混乱攻撃
   
4. **X-XSS-Protection**
   - ブラウザXSSフィルターを有効化
   - 欠落時のリスク: 低 - XSS攻撃面が増加
   
5. **Content-Security-Policy (CSP)**
   - インジェクション攻撃を防止
   - 欠落時のリスク: 中 - コンテンツインジェクション脆弱性
   
6. **Referrer-Policy**
   - リファラー情報漏洩を制御
   - 欠落時のリスク: 低 - 情報漏洩

**リスク評価:** ヘッダー欠落 = 低〜中リスク

---

### フェーズ2: CORSセキュリティテスト (2テスト)

**目的:** Cross-Origin Resource Sharing設定のセキュリティ確認。

**テスト内容:**
1. **ワイルドカードオリジン検出**
   - `Access-Control-Allow-Origin: *` をチェック
   - ペイロード: `Origin: https://evil-site.com`
   - 検出時のリスク: 高 - 任意のウェブサイトがAPIにアクセス可能
   
2. **悪意のあるオリジンの拒否**
   - 悪意のあるオリジンが受け入れられるかテスト
   - ペイロード: `Origin: https://evil-site.com`
   - 受け入れられた場合のリスク: 高 - 不正なクロスオリジンアクセス

**リスク評価:** CORS設定ミス = 高リスク

---

### フェーズ3: XSS脆弱性テスト (24テスト)

**目的:** クロスサイトスクリプティング脆弱性の検出。

**テスト済みペイロード (4個):**
1. `<script>alert('XSS')</script>` - 基本的なスクリプトインジェクション
2. `javascript:alert('XSS')` - JavaScriptプロトコル
3. `'"><script>alert('XSS')</script>` - コンテキストブレーキング
4. `<img src=x onerror=alert('XSS')>` - イベントハンドラーインジェクション

**テスト済みパラメータ (6個):**
- q, search, query, name, message, text

**合計テスト数:** 4ペイロード × 6パラメータ = 24テスト

**検出方法:** ペイロードがエスケープされずにレスポンスに現れるかチェック

**リスク評価:** XSS発見 = 高リスク - ユーザーブラウザでのコード実行

---

### フェーズ4: SQLインジェクションテスト (20テスト)

**目的:** SQLインジェクション脆弱性の検出。

**テスト済みペイロード (4個):**
1. `' OR '1'='1` - 認証バイパス
2. `'; DROP TABLE users; --` - ステートメント終了
3. `' UNION SELECT null, null --` - Unionベースの抽出
4. `admin'--` - コメントインジェクション

**テスト済みパラメータ (5個):**
- id, user, username, email, search

**合計テスト数:** 4ペイロード × 5パラメータ = 20テスト

**検出方法:** レスポンス内のSQLエラーパターンを検索:
- `sql syntax`, `mysql error`, `postgresql error`, `ora-[0-9]+`

**リスク評価:** SQLi発見 = 高リスク - データベース侵害が可能

---

### フェーズ5: 情報漏洩テスト (4テスト)

**目的:** 露出した機密ファイルとパスの検出。

**テスト済みパス:**
1. `/.git` - ソースコードリポジトリ
   - アクセス可能な場合のリスク: 高 - 完全なソースコード露出
   
2. `/.env` - 環境設定ファイル
   - アクセス可能な場合のリスク: 高 - データベース認証情報、APIキー露出
   
3. `/admin` - 管理者インターフェース
   - アクセス可能な場合のリスク: 中 - 不正な管理者アクセスが可能
   
4. `/phpmyadmin` - データベース管理インターフェース
   - アクセス可能な場合のリスク: 中 - データベース露出

**検出方法:** HTTP 200レスポンス = アクセス可能

**リスク評価:** 
- .git/.envアクセス可能 = 高リスク
- 管理者パスアクセス可能 = 中リスク

---

### フェーズ6: Struts 2 DevMode検出 (3テスト)

**目的:** Struts 2開発モードが本番環境で有効になっているか特定。

**テストパラメータ:**
1. `debug=xml` - XMLデバッグ出力
2. `debug=console` - コンソールデバッグ出力
3. `struts.devMode=true` - 直接devModeパラメータ

**検出パターン:**
- `devmode`
- `debug mode`
- `struts debug`
- `action mapping`

**重要性:**
DevModeは内部アプリケーション構造、アクションマッピング、デバッグ情報を露出し、攻撃者がアプリケーションを理解し悪用するために使用できます。

**リスク評価:** DevMode有効 = 高リスク

---

### フェーズ7: 包括的OGNLインジェクションテスト ⚠️ 重大

**目的:** OGNL式言語を介したリモートコード実行（RCE）脆弱性のテスト。

**これはSTRUTS 2アプリケーションにとって最も重要なフェーズです**

**21個のCVE**（S2-001からS2-062）をテスト:

#### テスト1: Content-Type OGNLインジェクション (S2-045, S2-046)

**CVE:** CVE-2017-5638 (S2-045), CVE-2017-9791 (S2-046)

**攻撃ベクター:** HTTP Content-Typeヘッダー

**ペイロード:**
```
Content-Type: %{(#_='multipart/form-data').(#dm=@ognl.OgnlContext@DEFAULT_MEMBER_ACCESS)}
```

**動作原理:**
- マルチパートパーサーでのOGNL評価を悪用
- Content-Typeヘッダー経由で任意のコード実行を許可
- システムコマンドをリモートで実行可能

**リスク:** 重大 - サーバーの完全な侵害

---

#### テスト2: リダイレクトパラメータOGNLインジェクション (S2-057)

**CVE:** CVE-2018-11776 (S2-057)

**攻撃ベクター:** URLリダイレクトパラメータ

**ペイロード:**
```
redirect:%{@java.lang.System@getProperty('user.name')}
```

**動作原理:**
- 名前空間設定の問題を悪用
- リダイレクトパラメータ内のOGNL式が評価される
- 任意のJavaコードを実行可能

**リスク:** 重大 - リモートコード実行

---

#### テスト3: URLパラメータOGNLインジェクション

**攻撃ベクター:** URLクエリパラメータ

**テスト済みペイロード (3個):**
1. `%{#context['xwork.MethodAccessor.denyMethodExecution']=false}`
2. `%{@java.lang.System@getProperty('user.name')}`
3. `${@java.lang.System@getProperty('os.name')}`

**動作原理:**
- URLパラメータがOGNL式を評価するかテスト
- Javaシステムプロパティへのアクセスを試行
- コマンド実行にエスカレート可能

**リスク:** 高〜重大

---

#### テスト4: 深層OGNLスキャン (18個の追加CVE)

**包括的CVEカバレッジ:**

**S2-001, S2-003, S2-005 (パラメータインジェクション)**
```
ペイロード: %{#a=(new java.lang.ProcessBuilder(new java.lang.String[]{'whoami'})).start()}
テスト: パラメータベースのOGNL評価
リスク: リクエストパラメータ経由のコマンド実行
```

**S2-007, S2-008, S2-009 (変換エラー)**
```
ペイロード: age=1&name=%{#context['xwork.MethodAccessor.denyMethodExecution']=false}
テスト: 型変換脆弱性
リスク: 変換エラー処理経由のRCE
```

**S2-012, S2-013 (アクションリダイレクト)**
```
ペイロード: redirect:%{#a=(new java.lang.ProcessBuilder(new java.lang.String[]{'id'})).start()}
テスト: リダイレクトベースインジェクション
リスク: リダイレクトパラメータ経由のRCE
```

**S2-015, S2-016 (ワイルドカードマッチング)**
```
ペイロード: *{#context['xwork.MethodAccessor.denyMethodExecution']=false}
テスト: ワイルドカードパターン脆弱性
リスク: アクションワイルドカード経由のRCE
```

**S2-029 (タグ属性)**
```
ペイロード: %{(#_='multipart/form-data').(#_memberAccess=@ognl.OgnlContext@DEFAULT_MEMBER_ACCESS)}
テスト: タグ属性インジェクション
リスク: JSPタグ経由のRCE
```

**S2-032, S2-033 (動的メソッド呼び出し - DMI)**
```
ペイロード: method:%{#_memberAccess=@ognl.OgnlContext@DEFAULT_MEMBER_ACCESS}
テスト: DMIベースエクスプロイト
リスク: method:プレフィックス経由のRCE
```

**S2-037 (RESTプラグイン)**
```
ペイロード: class.classLoader.resources.dirContext.docBase=.
テスト: RESTプラグイン脆弱性
リスク: RESTエンドポイント経由のRCE
```

**S2-053 (Freemarker)**
```
ペイロード: %{(#dm=@ognl.OgnlContext@DEFAULT_MEMBER_ACCESS)}
テスト: Freemarkerテンプレートインジェクション
リスク: テンプレート評価経由のRCE
```

**S2-059 (スキルフルマッチ)**
```
ペイロード: %{(#context['xwork.MethodAccessor.denyMethodExecution']=false)}
テスト: タグ属性スキルフルマッチング
リスク: タグ属性経由のRCE
```

**S2-062 (ParameterInterceptor)**
```
ペイロード: class['classLoader']['resources']['dirContext']['docBase']
テスト: パラメータインターセプターバイパス
リスク: パラメータ汚染経由のRCE
```

**テストエンドポイント:**
- ベースURL
- /index.action
- /login.action
- /user.action
- /admin.action

**検出方法:**
- OGNL例外パターンを検索
- 式評価の指標をチェック
- ProcessBuilder、memberAccessキーワードを検出

**リスク評価:** いずれかのOGNL脆弱性 = 重大 - サーバーの完全な侵害

---

### フェーズ8: アクションメソッド露出テスト ⚠️ 重大

**目的:** 直接メソッド呼び出し（DMI）脆弱性と名前空間トラバーサル問題の検出。

#### テスト1: 直接メソッド呼び出し (30組み合わせ)

**DMIとは？**
Struts 2は`!`構文を使用してアクションメソッドを直接呼び出すことができます:
- `login!execute.action` - execute()メソッドを呼び出し
- `admin!delete.action` - delete()メソッドを呼び出し

**重要性:**
DMIが有効な場合、攻撃者は内部メソッドを直接呼び出すことでセキュリティチェックをバイパスできます。

**テスト済みメソッド (6個):**
1. `execute` - メインアクション実行
2. `input` - 入力フォームレンダリング
3. `delete` - 削除操作
4. `update` - 更新操作
5. `admin` - 管理機能
6. `list` - リスト/列挙操作

**テスト済みベースアクション (5個):**
1. `login` - 認証アクション
2. `user` - ユーザー管理アクション
3. `admin` - 管理アクション
4. `action` - 汎用アクション
5. `default` - デフォルトアクション

**テストパターン:** `{base}!{method}.action`

**例:**
- `login!execute.action` - HTTP 200 = 露出
- `admin!delete.action` - HTTP 200 = 露出
- `user!update.action` - HTTP 200 = 露出

**合計テスト数:** 6メソッド × 5アクション = 30テスト

**検出方法:**
- HTTP 200または302レスポンス = メソッド露出
- HTTP 404 = メソッドアクセス不可（良好）

**リスク評価:** 露出メソッド = 高リスク - セキュリティ制御をバイパス

---

#### テスト2: 名前空間トラバーサルテスト (5パターン)

**目的:** 名前空間トラバーサル攻撃が可能かテスト。

**テスト済み名前空間:**
1. `/admin` - 管理者名前空間
2. `/api` - API名前空間
3. `/secure` - セキュアな名前空間
4. `/internal` - 内部操作名前空間
5. `/management` - 管理名前空間

**テストパターン:** `{TargetUrl}{namespace}/..`

**動作原理:**
- `../`トラバーサルが名前空間制限をバイパスするかテスト
- トラバーサルが不正な名前空間を露出するかチェック

**検出方法:**
- HTTP 200 + コンテンツマッチ = トラバーサル可能
- コンテンツパターン: `admin`, `secure`, `internal`

**リスク評価:** トラバーサル可能 = 中リスク

---

### フェーズ9: OWASP ZAP包括スキャン (フルモードのみ)

**目的:** OWASP ZAPの50+脆弱性ルールを使用した深層ペネトレーションテスト。

**要件:** OWASP ZAPインストール済み (https://www.zaproxy.org/download/)

**テスト内容:**
- ✅ 高度なXSS検出
- ✅ 高度なSQLインジェクション（ブラインド、タイムベース）
- ✅ コマンドインジェクション
- ✅ パストラバーサル
- ✅ XXE (XML External Entity)
- ✅ CSRF脆弱性
- ✅ セッション管理の問題
- ✅ クッキーセキュリティ（SameSite、HttpOnly、Secure）
- ✅ ユーザーエージェントファジング
- ✅ その他40+セキュリティチェック

**出力:** `zap-reports/`フォルダに詳細なHTMLレポートを保存

**スキャンタイプ:**
1. **スパイダースキャン** - すべてのアプリケーションURLを発見
2. **パッシブスキャン** - レスポンスを分析（攻撃なし）
3. **アクティブスキャン** - 脆弱性を積極的にテスト

**検出されるリスクレベル:** 高、中、低、情報

---

## 📊 結果の理解

### リスクスコア計算

```
リスクスコア = (高 × 10) + (中 × 3) + (低 × 1)
最大スコア = 100（上限）
```

### リスクレベルの説明

**高リスク (10ポイント)** - 即座の対応が必要
- **例:** OGNLインジェクション、露出したアクションメソッド、DevMode有効
- **影響:** リモートコード実行、サーバーの完全な侵害
- **対応:** 直ちに修正、Struts 2のアップグレード、DMIの無効化

**中リスク (3ポイント)** - 速やかな修正
- **例:** CSPヘッダー欠落、アクセス可能な管理パス、名前空間トラバーサル
- **影響:** 攻撃面の増加
- **対応:** セキュリティヘッダーの追加、アクセス制限、設定の修正

**低リスク (1ポイント)** - 推奨修正
- **例:** セキュリティヘッダー欠落（X-Frame-Optionsなど）
- **影響:** 軽微なセキュリティ改善
- **対応:** セキュリティベストプラクティスに従ってヘッダーを追加

### リスクスコアの解釈

- **0-20:** 低リスク - 良好なセキュリティ状態
- **21-40:** 中リスク - いくつかの改善が必要
- **41-60:** 高リスク - 複数の問題が発見
- **61+:** 重大 - 即座の修復が必要

---

## 💡 使用例

### 例1: ローカルホストアプリケーションのテスト
```powershell
.\RunStruts2SecurityTest.bat http://localhost:8080/myapp Quick
```

### 例2: リモートステージング環境のテスト
```powershell
.\RunStruts2SecurityTest.bat https://staging.example.com/myapp Quick
```

### 例3: ZAP付きフルスキャン
```powershell
# まずZAPをインストール: https://www.zaproxy.org/download/
.\RunStruts2SecurityTest.bat http://localhost:8080/myapp Full
```

### 例4: Dockerアプリケーション
```powershell
# DockerアプリはlocalhostではなくhostDocker.internalを使用
.\RunStruts2SecurityTest.bat http://host.docker.internal:7070/myapp Quick
```

### 例5: カスタムZAPインストールパス
```powershell
powershell -ExecutionPolicy Bypass -File .\Struts2-SecurityTest.ps1 `
  -TargetUrl "http://localhost:8080/myapp" `
  -Mode Full `
  -ZapPath "D:\Tools\ZAP\zap.bat"
```

---

## 🔧 トラブルシューティング

### ターゲットに接続できない
```
✗ ターゲットURLに接続できません
エラー: リモートサーバーがエラーを返しました: (404) Not Found
```

**解決方法:**
1. アプリケーションが実行中か確認: ブラウザでまずURLをテスト
2. URLのスペルとポート番号を確認
3. Dockerアプリの場合: `localhost`の代わりに`host.docker.internal`を使用
4. ファイアウォール設定を確認

### ZAPが見つからない(フルモードのみ)
```
! ZAPが見つかりません: C:\Program Files\ZAP\Zed Attack Proxy\zap.bat
! ZAPスキャンをスキップ
```

**解決方法:**
1. https://www.zaproxy.org/download/ からOWASP ZAPをインストール
2. `-ZapPath`パラメータでカスタムパスを指定
3. またはクイックモードを使用(ZAP不要)

### ZAPポート競合(フルモードのみ)
```
Failed to start the main proxy: java.net.BindException Address already in use: bind
```

**問題:** ZAPが使用する**ポート7777**が既に別のアプリケーションによって使用されています。

**解決方法:**
1. ポート7777を使用しているアプリケーションを停止
2. 確認コマンド: `netstat -ano | findstr :7777`
3. またはクイックモードを使用(ZAP不要、ポート要件なし)

---

## 🎯 各モードの使い分け

### クイックモード (2-3分) - 推奨

**使用シーン:**
- ✅ 高速なStruts 2脆弱性評価が必要
- ✅ CI/CDパイプライン統合
- ✅ デプロイ前のセキュリティチェック
- ✅ 定期的なセキュリティ評価
- ✅ OWASP ZAPが利用不可

**得られるもの:**
- 8つのセキュリティテストフェーズすべて
- 21個のOGNL CVEテスト
- 30個のアクションメソッドテスト
- 完全なStruts 2カバレッジ

### フルモード (20-30分)

**使用シーン:**
- ✅ 包括的なセキュリティ監査が必要
- ✅ 本番前テスト
- ✅ ペネトレーションテスト業務
- ✅ コンプライアンス要件（PCI-DSSなど）
- ✅ 詳細な脆弱性レポートが必要

**得られるもの:**
- クイックモードのすべて
- OWASP ZAP深層スキャン（50+チェック）
- 詳細なHTMLレポート
- 高度な脆弱性検出

---

## ✨ 主な利点

### 1. ゼロセットアップ
- ✅ WSLインストール不要
- ✅ Java不要
- ✅ jqパーサー不要
- ✅ あらゆるWindows マシンで即座に動作

### 2. Windows ネイティブ
- ✅ localhostへの直接アクセス
- ✅ IP変換の問題なし
- ✅ 改行問題なし（CRLF/LF）
- ✅ Windows開発に最適

### 3. 包括的なStruts 2テスト
- ✅ 21個のOGNL CVE（S2-001からS2-062）
- ✅ 30個のアクションメソッド露出テスト
- ✅ 5個の名前空間トラバーサルテスト
- ✅ DevMode検出

### 4. 高速実行
- ✅ クイック: 2-3分
- ✅ フル: 20-30分
- ✅ 起動遅延なし

### 5. 本番環境対応
- ✅ 実際の脆弱性を検出
- ✅ 明確で実行可能な出力
- ✅ リスクスコアリング
- ✅ 詳細な修復ガイダンス

---

## 📁 ファイル

- **Struts2-SecurityTest.ps1** - メインセキュリティスキャナー
- **RunStruts2SecurityTest.bat** - 便利なランチャー
- **README.md** - このドキュメント
- **zap-reports/** - ZAPスキャンレポート（フルモード）

---

## 🛡️ セキュリティ警告

**⚠️ 許可されたテストのみ**

これらのテストは読み取り専用ですが、エラーログを生成する可能性があります。以下のみで使用してください:
- ✅ 自分のアプリケーション
- ✅ 開発/ステージング環境
- ✅ テスト許可を持つシステム

**以下では実行しないでください:**
- ❌ 許可のない本番システム
- ❌ サードパーティアプリケーション
- ❌ 所有していないシステム

---

## 📚 リソース

- **OWASP ZAP:** https://www.zaproxy.org/
- **Strutsセキュリティ:** https://struts.apache.org/security/
- **CVEデータベース:** https://cve.mitre.org/
- **OWASP Top 10:** https://owasp.org/www-project-top-ten/

---

**⚡ 数秒でテスト開始 - セットアップ不要！**
